import numpy as np
import matplotlib.pyplot as plt

# Define functions and their derivatives for various exponents
def combined_function(d, a):
    return (1 - np.exp(-(d**2)/a))**2 + (1 - np.exp(-((d-5)**2)/a))**2

def combined_derivative(d, a):
    return 2 * (1 - np.exp(-(d**2)/a)) * ((2 * d) / a * np.exp(-(d**2)/a)) + \
           2 * (1 - np.exp(-((d-5)**2)/a)) * ((2 * (d-5)) / a * np.exp(-((d-5)**2)/a))

# Generate d values from 0 to 5
d_focused = np.linspace(0, 5, 500)

# Plotting the derivatives for various exponents
plt.figure(figsize=(14, 8))
exponents = [0.1, 0.3, 1, 5, 10, 30]
for a in exponents:
    derivative_values = combined_derivative(d_focused, a)
    plt.plot(d_focused, derivative_values, label=f'Derivative with exponent {a}')

plt.title('Comparison of Derivatives for Different Exponents ($s_0=0 , s_1=5$)')
plt.xlabel('$s_2$')
plt.ylabel('Derivative of renyi divergence')
plt.legend()
plt.grid(True)
plt.show()
plt.figure(figsize=(14, 8))
en = 0
for a in exponents:
    if en == 0:
        _linestyle='-.'
    elif en == 1:
        _linestyle='--'
    elif en == 2:
        _linestyle=':'
    elif en == 3:
        _linestyle='--'
    else:
        _linestyle=':'
    derivative_values = combined_function(d_focused, a)
    plt.plot(d_focused, derivative_values, label=f'Information Gain with B $(\~\psi_{{{a}}} (s_2)|| \~\psi_{{{a}}}(s_0)+\~\psi_{{{a}}}(s_1))$ ', linestyle = _linestyle)
    en = en + 1


plt.ylim(0, 3)
plt.tight_layout()
plt.savefig("figurename.pdf")
plt.show()
plt.legend(loc='upper right', fontsize='large')
plt.grid(True)
plt.show()
